$(document).ready(function () {
    let delaiMesure = 5000;
    let delaiError = 4000;

    // Définir les données JSON
    // Exemple : relevé de température le 3/4/25
    // https://www.meteo60.fr/stations-releves/station-jour?station_id=LFLD-07255&date=03%2F04%2F2025

    function loadMeasures() {
        $.ajax({
            url: 'scripts/lireTable.php',
            method: 'GET',
            dataType: 'json', // Format attendu
            success: function (data) {
                // Configurer la source de données
                var source = {
                    localdata: data,
                    datatype: "array",
                    datafields: [
                        { name: 'H0', type: 'number' },{ name: 'T0', type: 'number' },
                        { name: 'H1', type: 'number' },{ name: 'T1', type: 'number' },
                        { name: 'H', type: 'number' },{ name: 'T', type: 'number' }
                    ]
                };

                var dataAdapter = new $.jqx.dataAdapter(source);

                // Configurer jqxChart
                var settings = {
                    title: "Relevé de températures 0 à 23h",
                    description: "(0h et 1h simulées par des potentiomètres placés sur A0 et A1 [carte MKR1010 & Serveur HTTP V6])",
                    enableAnimations: false,
                    showLegend: true,
                    padding: { left: 10, top: 10, right: 10, bottom: 10 },
                    titlePadding: { left: 0, top: 0, right: 0, bottom: 10 },
                    source: dataAdapter,
                    xAxis: {
                        dataField: 'H',
                        displayText: 'H local'
                    },
                    colorScheme: 'scheme01',
                    seriesGroups: [
                        {
                            type: 'column', // Type de graphique (ex. : 'column', 'line', 'area', 'bar')
                            columnsGapPercent: 50,
                            series: [
                                { dataField: 'T0', displayText: 'A0', color: '#FF0000' },
                                { dataField: 'T1', displayText: 'A1', color: '#00FF00' },
                                { dataField: 'T', displayText: 'Température (°C) le 3/4/2025' , color: '#0000FF'}
                            ]
                        }
                    ]
                };

                // Initialiser le jqxChart
                $('#jqxChart').jqxChart(settings);
            },
            timeout: delaiError,
            error: function (xhr, status, error) {
                console.error('Erreur lors de la récupération des données JSON:', error);
            }
        });
    }

    loadMeasures(); // Exécuté une fois au chargement de la page

    setInterval(function () { // Boucle infinie, s'exécute
        loadMeasures() // toutes les ns
    }, delaiMesure);
});